package be.re.util;

import java.io.PrintStream;
import java.io.PrintWriter;



/**
 * This class exists to cross interfaces without disturbing them when the
 * clients of such interfaces also provide parts to that can throw specific
 * exceptions. All methods are delegated to the encapsulated exeception. This
 * makes the encapsulation "invisible". The catcher can catch it like any other
 * <code>Exception</code>, while "seeing" only the underlying exception.
 * @author Werner Donn\u00e9
 */

public class UncheckedCapsule extends RuntimeException

{

  private Throwable	e;



  public
  UncheckedCapsule(Throwable e)
  {
    this.e = e != null ? e : new Exception("null");
  }



  public Throwable
  getException()
  {
    return e;
  }



  public String
  getLocalizedMessage()
  {
    return e.getLocalizedMessage();
  }



  public String
  getMessage()
  {
    return e.getMessage();
  }



  public void
  printStackTrace()
  {
    e.printStackTrace();
  }



  public void
  printStackTrace(PrintStream s)
  {
    e.printStackTrace(s);
  }



  public void
  printStackTrace(PrintWriter s)
  {
    e.printStackTrace(s);
  }



  public String
  toString()
  {
    return e.toString();
  }

} // UncheckedCapsule
