package be.re.tools;

import be.re.io.PipedInputStream;
import be.re.io.PipedOutputStream;
import be.re.xml.sax.CatalogResolver;
import be.re.xml.sax.Tee;
import com.renderx.xep.Driver;
import com.renderx.xep.gen.backends.H4PDF;
import com.renderx.xep.gen.backends.H4PS;
import com.renderx.xep.gen.backends.H4XML;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;



public class XEP

{

  private static ContentHandler
  getContentHandler(String xmlFile, String pdfFile, String psFile)
    throws IOException
  {
    List	handlers = new ArrayList();

    if (xmlFile != null)
    {
      H4XML.init();

      H4XML	generator = new H4XML();

      generator.setOutFile(getOutputStream(xmlFile));
      handlers.add(generator);
    }

    if (pdfFile != null)
    {
      H4PDF.init();

      H4PDF	generator = new H4PDF();

      generator.setOutFile(getOutputStream(pdfFile));
      handlers.add(generator);
    }

    if (psFile != null)
    {
      H4PS.init();

      H4PS	generator = new H4PS();

      generator.setOutFile(getOutputStream(psFile));
      handlers.add(generator);
    }

    return
      new Tee
      (
        (ContentHandler[]) handlers.toArray(new ContentHandler[handlers.size()])
      );
  }



  private static InputSource
  getInputSource
  (
    String		foSource,
    final String	xmlSource,
    final String	styleSheet,
    final String	catalog
  ) throws IOException
  {
    if (foSource != null)
    {
      return new InputSource(getSystemId(foSource));
    }

    PipedInputStream		in = new PipedInputStream();
    final PipedOutputStream	out = new PipedOutputStream(in);

    new Thread
    (
      new Runnable()
      {
        public void
        run()
        {
          try
          {
            XMLReader	reader =
              SAXParserFactory.newInstance().newSAXParser().getXMLReader();

            if (catalog != null)
            {
              reader.setEntityResolver
              (
                new CatalogResolver(new URL(getSystemId(catalog)))
              );
            }

            TransformerFactory.newInstance().
              newTransformer(new StreamSource(getSystemId(styleSheet))).
              transform
              (
                new SAXSource(reader, new InputSource(getSystemId(xmlSource))),
                new StreamResult(out)
              );

              out.close();
          }

          catch (Throwable e)
          {
            e.printStackTrace();
            System.exit(1);
          }
        }
      }
    ).start();

    InputSource	result = new InputSource(in);

    result.setSystemId(getSystemId(xmlSource));

    return result;
  }



  private static OutputStream
  getOutputStream(String name) throws IOException
  {
    return
      be.re.net.Util.isUrl(name) ?
        new URL(name).openConnection().getOutputStream() :
        new FileOutputStream(name);
  }



  private static String
  getSystemId(String name) throws IOException
  {
    return
      be.re.net.Util.isUrl(name) ?
        name : be.re.net.Util.fileToUrl(new File(name)).toString();
  }



  public static void
  main(String[] args)
  {
    String	catalog = null;
    String	foSource = null;
    String	pdfFile = null;
    String	psFile = null;
    String	styleSheet = null;
    String	xmlFile = null;
    String	xmlSource = null;

    for (int i = 0; i < args.length; ++i)
    {
      if (args[i].equals("-fo"))
      {
        if (i == args.length - 1)
        {
          usage(1);
        }

        foSource = args[++i];
      }
      else
      {
        if (args[i].equals("-xml"))
        {
          if (i == args.length - 1)
          {
            usage(1);
          }

          xmlSource = args[++i];
        }
        else
        {
          if (args[i].equals("-xsl"))
          {
            if (i == args.length - 1)
            {
              usage(1);
            }

            styleSheet = args[++i];
          }
          else
          {
            if (args[i].equals("-c"))
            {
              if (i == args.length - 1)
              {
                usage(1);
              }

              catalog = args[++i];
            }
            else
            {
              if (args[i].equals("-at"))
              {
                if (i == args.length - 1)
                {
                  usage(1);
                }

                xmlFile = args[++i];
              }
              else
              {
                if (args[i].equals("-pdf"))
                {
                  if (i == args.length - 1)
                  {
                    usage(1);
                  }

                  pdfFile = args[++i];
                }
                else
                {
                  if (args[i].equals("-ps"))
                  {
                    if (i == args.length - 1)
                    {
                      usage(1);
                    }

                    psFile = args[++i];
                  }
                }
              }
            }
          }
        }
      }
    }

    if
    (
      (
        foSource != null	&&
        (
          xmlSource != null	||
          styleSheet != null
        )
      )				||
      (
        xmlSource != null	&&
        styleSheet == null
      )				||
      (
        xmlSource == null	&&
        styleSheet != null
      )				||
      (
        foSource == null	&&
        xmlSource == null
      )				||
      (
        xmlFile == null		&&
        pdfFile == null		&&
        psFile == null
      )
    )
    {
      usage(1);
    }

    try
    {
      Driver.init();

      Driver.render
      (
        getInputSource(foSource, xmlSource, styleSheet, catalog),
        getContentHandler(xmlFile, pdfFile, psFile)
      );
    }

    catch (Throwable e)
    {
      e.printStackTrace();
      System.exit(1);
    }
  }



  private static void
  usage(int exitCode)
  {
    System.err.println
    (
      "Usage: be.re.tools.XEP\n" +
      "       [-c file_or_url]\n" +
      "       -fo file_or_url or -xml file_or_url -xsl file_or_url\n" +
      "       -at file_or_url\n" +
      "       -pdf file_or_url\n" +
      "       -ps file_or_url"
    );

    System.exit(exitCode);
  }

} // XEP
