package be.re.net;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;



/**
 * Several Internet protocols use headers. This class can be used to manage
 * them. Headers can occur more than once. Even name/value pairs may be
 * dupplicated.
 * @author Werner Donn\u00e9
 */

public class Headers

{

  private List	headers = new ArrayList();



  public void
  add(String name, String value)
  {
    headers.add(new Header(name, value));
  }



  public void
  add(Headers headers)
  {
    Header[]	all = headers.getAll();

    for (int i = 0; i < all.length; ++i)
    {
      add(all[i].getName(), all[i].getValue());
    }
  }



  public void
  clear()
  {
    headers.clear();
  }



  public String[]
  get(String name)
  {
    List	values = new ArrayList();

    for (Iterator i = headers.iterator(); i.hasNext();)
    {
      Header	tuple = (Header) i.next();

      if (tuple.name.equalsIgnoreCase(name))
      {
        values.add(tuple.value);
      }
    }

    return (String[]) values.toArray(new String[values.size()]);
  }



  public Header[]
  getAll()
  {
    return (Header[]) headers.toArray(new Header[headers.size()]);
  }



  public void
  remove(String name)
  {
    for (Iterator i = headers.iterator(); i.hasNext();)
    {
      Header	tuple = (Header) i.next();

      if (tuple.name.equalsIgnoreCase(name))
      {
        i.remove();
      }
    }
  }



  public void
  remove(String name, String value)
  {
    for (Iterator i = headers.iterator(); i.hasNext();)
    {
      Header	tuple = (Header) i.next();

      if (tuple.name.equalsIgnoreCase(name) && tuple.value.equals(value))
      {
        i.remove();
      }
    }
  }



  public void
  set(String name, String value)
  {
    remove(name);
    add(name, value);
  }



  public void
  set(String name, String oldValue, String newValue)
  {
    for (Iterator i = headers.iterator(); i.hasNext();)
    {
      Header	tuple = (Header) i.next();

      if (tuple.name.equalsIgnoreCase(name) && tuple.value.equals(oldValue))
      {
        tuple.value = newValue;
      }
    }
  }



  public int
  size()
  {
    return headers.size();
  }



  public String
  toString()
  {
    String	result = "";

    for (Iterator i = headers.iterator(); i.hasNext();)
    {
      Header	tuple = (Header) i.next();

      result += tuple.name + ":" + tuple.value + "\r\n";
    }

    return result;
  }



  public class Header

  {

    private String	name;
    private String	value;



    public
    Header(String name, String value)
    {
      this.name = name;
      this.value = value;
    }



    public String
    getName()
    {
      return name;
    }



    public String
    getValue()
    {
      return value;
    }

  } // Header

} // Headers
